package w83a.w83aManager;

import java.util.List;

import w83a.Thread.W83ANotificacionThread;
import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aDAO.W83aFactoriaDAO;
import w83a.w83aUtilidadesComunes.W83aUtilidades;
import w83a.w83aUtilidadesLibroRegistro.W83aLibroRegistro;
import w83a.w83aUtilidadesLibroRegistro.W83aLibroRegistroException;

public class W83aComunes  implements W83aIComunes {
	public w83a.w83aBeans.W83aUsuarioXLNetsBean buscarDatosUsuario(w83a.w83aBeans.W83aUsuarioXLNetsBean param) throws Exception{
		
		String dni="";
		
		W83aUsuarioXLNetsBean usuario = new W83aUsuarioXLNetsBean();
		if (param.getDniUsuario().length()==8){
			if (param.getDniUsuario().substring(0,1).matches("[0-9]")){
				dni=W83aUtilidades.letraDNI(param.getDniUsuario());
			}
			else{
				dni=W83aUtilidades.letraNIE(param.getDniUsuario());
			}
		}
		param.setDniCompleto(dni);
		//Para que podamos entrar con W83BUTRA
		if ("W83B-01".equals(param.getDniUsuario())){
			param.setDniCompleto("W83B-01");
			
		}
		List listaUsuario = W83aFactoriaDAO.getComunesDAO().buscarDatosUsuario(param);
		
		if(null!=listaUsuario&& listaUsuario.size()>0){
			usuario = (W83aUsuarioXLNetsBean)listaUsuario.get(0);
			usuario.setExisteEnBD("si");
		}
		else{
			usuario=param;
			usuario.setExisteEnBD("no");
		}
		return usuario;	
	}
	
public w83a.w83aBeans.W83aUsuarioXLNetsBean darAltaRegistroNuevoNumeroEntradaDelegacion(w83a.w83aBeans.W83aUsuarioXLNetsBean param) throws Exception{
		
		W83aUsuarioXLNetsBean usuario = new W83aUsuarioXLNetsBean();
		
		usuario = refrescarUsuarioDelegacion(param);
		
		//String anyoActa = usuario.getObservaciones().split("/")[1];
	//	String territorioActa = usuario.getObservaciones().split("/")[0];
		
		String numActa = usuario.getObservaciones().split("/").length==3 ? usuario.getObservaciones().split("/")[2] : "";
		
		/*if("actas".equals(usuario.getTipo())){
			numActa = ((W83aIActas)(W83aActas.class.newInstance())).calcularNumActa(numActa, anyoActa, territorioActa);
			if("-1".equals(numActa)){
				usuario.setNumRegistro("-1");
				usuario.setFechaRegistro("-1");
				
				return usuario;	
			}
			usuario.setObservaciones("Acta n: "+territorioActa+"/"+anyoActa+"/"+numActa);
			usuario.setPoblacion(territorioActa);
		}else if("preavisos".equals(usuario.getTipo())){
			W83aPreavisosBean beanPreaviso = new W83aPreavisosBean();
			
			beanPreaviso.setAnyoPreaviso(anyoActa);
			beanPreaviso.setCodTerritorio(territorioActa);
			beanPreaviso.setNum_preaviso(numActa);
			
			HashMap mapaPreavisos = ((W83aIPreavisos)(W83aPreavisos.class.newInstance())).calcularNumPreaviso(beanPreaviso);
			
			numActa = (String)mapaPreavisos.get("numPreaviso");
			
			if("-1".equals(numActa)){
				usuario.setNumRegistro("-1");
				usuario.setFechaRegistro("-1");
				
				return usuario;	
			}
			usuario.setObservaciones("Preavisos n: "+territorioActa+"/"+anyoActa+"/"+numActa);
			usuario.setPoblacion(territorioActa);
			
			String empresa = usuario.getEmpresa();
			
			String[] codsPromotores= empresa.split(",");
			 StringBuffer codPromotores = new StringBuffer(W83aClsConstantes.UNO);				 
			 
			 codPromotores.append(codsPromotores[0]);
			 
			for (int j=0;j<codsPromotores.length;j++){
				codPromotores.append("-").append(codsPromotores[j]);				
			}
			empresa = codPromotores.toString();
			usuario.setEmpresa(empresa);
		}else if("impugnaciones".equals(usuario.getTipo())){
			W83aImpugnacionBean beanImpugnacion = new W83aImpugnacionBean();
			
			beanImpugnacion.setAnyoImpugnacion(anyoActa);
			beanImpugnacion.setTerritorioImpugnacion(territorioActa);
			beanImpugnacion.setNumImpugnacion(numActa);
			
			W83aIImpugnaciones iImpugnaciones = ((W83aIImpugnaciones)(W83aImpugnaciones.class.newInstance()));
			boolean existeImpugnacion = false;
			
			if(StringUtils.isNotEmpty(numActa)){
				existeImpugnacion = iImpugnaciones.existeImpugnacion(beanImpugnacion);
			}
			
			if(existeImpugnacion){
				usuario.setNumRegistro("-1");
				usuario.setFechaRegistro("-1");
				
				return usuario;	
			}
			
			numActa = iImpugnaciones.calcularNumImpugnacion(beanImpugnacion);
			if("-1".equals(numActa)){
				usuario.setNumRegistro("-1");
				usuario.setFechaRegistro("-1");
				
				return usuario;	
			}
			usuario.setObservaciones("Impugnaciones n: "+territorioActa+"/"+anyoActa+"/"+numActa);
			usuario.setPoblacion(territorioActa);

		}else if("incidencias".equals(usuario.getTipo())){
			W83aNuevaIncidenciasBean incidencia = new W83aNuevaIncidenciasBean();
			
			incidencia.setIncidenciaAnyo(anyoActa);
			incidencia.setIncidenciaTerritorio(territorioActa);
			incidencia.setIncidenciaNumero(numActa);

			
			if(StringUtils.isEmpty(incidencia.getIncidenciaNumero())){
				incidencia.setIncidenciaNumero(
						String.valueOf(
								Integer.parseInt(W83aFactoriaDAO.getIncidenciasDAO().maxIncidencia(incidencia.getIncidenciaAnyo(),incidencia.getIncidenciaTerritorio()))+1
								)
						);
				numActa = incidencia.getIncidenciaNumero();
			}
			
			usuario.setObservaciones("Incidencia n: "+territorioActa+"/"+anyoActa+"/"+numActa);
			
			if(StringUtils.isEmpty(usuario.getEmpresa())){
				usuario.setEmpresa(territorioActa+"/"+anyoActa+"/"+numActa);
			}
			usuario.setPoblacion(territorioActa);
		}
		*/
		String[] resul = null;
		
		
		try{
			//resul = W83aLibroRegistro.getAltaRegistro(true, usuario.getModelo(), "E", "E", usuario.getEmpresa(), usuario.getPoblacion(), "", usuario.getObservaciones(), usuario);
			String sesionToken = W83ANotificacionThread.getTokenXLNets("w83a");
			resul = W83aLibroRegistro.crearEntradaRegistro(sesionToken, param);
			usuario.setObservaciones(numActa);
		}catch (W83aLibroRegistroException e) {
			
		}
		if(null!=resul){
			usuario.setNumRegistro(resul[0]);
			usuario.setFechaRegistro(resul[1]);
		}else{
			usuario.setNumRegistro(null);
			usuario.setFechaRegistro(null);
		}
		
		return usuario;	
	}
	
	public w83a.w83aBeans.W83aUsuarioXLNetsBean refrescarUsuarioDelegacion(w83a.w83aBeans.W83aUsuarioXLNetsBean param) throws Exception{
		
		W83aUsuarioXLNetsBean usuario = new W83aUsuarioXLNetsBean();
		
		List listaUsuario = W83aFactoriaDAO.getComunesDAO().buscarDatosUsuarioLimitado(param);
		
		if(null!=listaUsuario&& listaUsuario.size()>0){
			usuario = (W83aUsuarioXLNetsBean)listaUsuario.get(0);
		}else{
			usuario = param;
		}
		
		return usuario;	
	}
	
	public w83a.w83aBeans.W83aUsuarioXLNetsBean refrescarRegistroAutomaticoUsuarioDelegacion(w83a.w83aBeans.W83aUsuarioXLNetsBean param) throws Exception{
		
		W83aUsuarioXLNetsBean usuario = new W83aUsuarioXLNetsBean();
		
		List listaUsuario = W83aFactoriaDAO.getComunesDAO().buscarDatosUsuarioLimitadoRegistroAutomat(param);
		
		if(null!=listaUsuario&& listaUsuario.size()>0){
			usuario = (W83aUsuarioXLNetsBean)listaUsuario.get(0);
		}else{
			usuario = param;
		}
		
		return usuario;	
	}
}
